#ifndef _ARMY_H_
#define _ARMY_H_

#include "map.h"

typedef struct ARMY
{
	int id; /* unique id */
	int x, y;
	int dx, dy;
	int player;
	int size;
	int idle;
	int moves_left;
	struct ARMY *next;
} ARMY;

ARMY* army_add(ARMY **armies);
ARMY *army_remove(ARMY **armies, ARMY *army);
void army_destroy(ARMY **armies);

int army_check_spot(ARMY *army, int x, int y);
void army_print(ARMY *armies, int x, int y, BITMAP *buffer, int bx, int by);
ARMY *army_get_idle(ARMY *army, int x, int y);
int army_get_enemy(ARMY *army, int x, int y, int player);
int army_get_enemy_size(ARMY *army, int x, int y, int player);

#endif
